////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/PasswordException.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link PasswordError} object is used to provide detailed information about a password related
 * issue during a flow execution.
 */
NS_REFINED_FOR_SWIFT
@interface PasswordError : NSObject


/** error code attached to the error (see OrchestrationErrorCodes.h) */
@property (nonatomic, readonly) int errorCode;

/** exception attached to the error */
@property (nonatomic, readonly, nullable) NSException *exception;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)new NS_UNAVAILABLE;

/**
 * Constructor
 * @param exception exception returned during a flow execution
 */
- (instancetype)initWithPasswordException:(PasswordException *)exception;


@end

NS_ASSUME_NONNULL_END
